<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Notify demo</title>
</head>
<body>
  <h3>Notification demo</h3>

  <script>
  // check browser support
  if (!("Notification" in window)) {
    alert("This browser does not support desktop notifications. Use Chrome/Edge/Firefox.");
  }

  // Request permission once
  function askPermission() {
    if (Notification.permission === "default") {
      Notification.requestPermission().then(function(permission) {
        console.log('Notification permission:', permission);
      });
    }
  }
  askPermission();

  // keep last shown id in localStorage to avoid repeats
  const LAST_ID_KEY = 'lastNotifId_v1'; // change key if you change logic
  function getLastId() {
    return parseInt(localStorage.getItem(LAST_ID_KEY) || '0', 10);
  }
  function setLastId(id) {
    localStorage.setItem(LAST_ID_KEY, String(id));
  }

  // Show notification (with click behavior)
  function showNotification(title, message, id) {
    if (Notification.permission !== "granted") return;
    const options = {
      body: message,
      tag: 'notif-' + id, // prevents duplicates
      renotify: false,
      data: { id }
    };
    try {
      const n = new Notification(title, options);
      n.onclick = function (evt) {
        // customize: focus tab, open page, etc.
        window.focus();
        // optionally navigate:
        // window.location.href = '/somepage.php?notif_id=' + id;
        n.close();
      };
    } catch (e) {
      console.error('Notification error', e);
    }
  }

  // Poll function
  async function checkNotify() {
     
    try {
      const resp = await fetch('check-notify.php', { cache: 'no-store' });
      if (!resp.ok) return;
      const data = await resp.json();
      if (data.notify) {
        const last = getLastId();
        if (data.id > last) {
          // show
          showNotification(data.title || 'New', data.message || '', data.id);
          setLastId(data.id);

          // optional: tell server mark-sent
          // await fetch('/mark-sent.php', {
          //   method: 'POST',
          //   headers: { 'Content-Type': 'application/json' },
          //   body: JSON.stringify({ id: data.id })
          // });
        }
      }
    } catch (err) {
      console.error('checkNotify error', err);
    }
  }

  // start polling every 3 seconds
  checkNotify(); // first call immediately
  setInterval(checkNotify, 500);
  </script>
</body>
</html>
