<?php
header('Content-Type: application/json; charset=utf-8');

include 'connection_sql.php';  // must define $pdo

try {

    if (!isset($pdo)) {
        throw new Exception("PDO connection (\$pdo) not found in connection_sql.php");
    }

    $sql = "SELECT id, title, message, created_at 
            FROM notifications 
            WHERE is_sent = 0 
            ORDER BY id ASC 
            LIMIT 1";

    $stmt = $pdo->prepare($sql);

    if (!$stmt) {
        throw new Exception("SQL Prepare Failed: " . implode(" | ", $pdo->errorInfo()));
    }

    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        echo json_encode([
            'notify' => true,
            'id' => (int)$row['id'],
            'title' => $row['title'],
            'message' => $row['message'],
            'created_at' => $row['created_at']
        ]);
        exit;
    }

    echo json_encode(['notify' => false]);

} catch (Exception $e) {
    echo json_encode([
        'notify' => false,
        'error' => $e->getMessage()
    ]);
}
